/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.IVWTaskMenuInfo;
import filenet.vw.apps.taskman.IVWTaskProcessLookup;
import filenet.vw.apps.taskman.VWTaskApplicationSettings;
import filenet.vw.apps.taskman.VWTaskContentViewPane;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskRootNode;
import filenet.vw.apps.taskman.VWTaskTablePanel;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.message.VWConsoleEvent;
import filenet.vw.apps.taskman.message.VWConsoleListener;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.base.IVWConsole;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.IVWConsoleHandler;
import filenet.vw.base.logging.Level;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Element;

public abstract class VWTaskBaseNode
extends DefaultMutableTreeNode
implements ActionListener,
IVWTaskMenuInfo,
IVWConsole,
VWConsoleListener,
IVWTaskProcessLookup {
    protected static final ImageIcon unknownIcon32 = VWImageLoader.createImageIcon("unknode32.gif");
    protected static final ImageIcon unknownIcon16 = VWImageLoader.createImageIcon("unknode16.gif");
    public static final int NODE_TYPE_UNKNOWN = 0;
    public static final int NODE_TYPE_FOLDER = 1;
    public static final int NODE_TYPE_ROUTER_ADMIN = 4;
    public static final int NODE_TYPE_ROUTER = 5;
    public static final int NODE_TYPE_WFSERVICES = 6;
    public static final int NODE_TYPE_RDBOBJ = 17;
    public static final int NODE_TYPE_SVC_MANAGER = 18;
    public static final int NODE_TYPE_SVC_ADAPTOR = 19;
    public static final int NODE_TYPE_SIM_ENGINE = 20;
    public static final int NODE_TYPE_RULES_ENGINE = 21;
    public static final int NODE_TYPE_PROCESS_ANALYZER = 22;
    public static final int NODE_TYPE_SYSTEM = 48;
    public static final int NO_ORDER = 0;
    public static final int ASCENDING_ORDER = 1;
    public static final int DESCENDING_ORDER = 2;
    private VWTaskContentViewPane m_contentPane = null;
    private IVWConsoleHandler m_consoleHandler = null;
    private String m_name = null;
    private String m_basePropertyKey = null;
    private Properties m_properties = null;
    private String m_propertiesPath = null;
    private ImageIcon m_icon32 = unknownIcon32;
    private ImageIcon m_icon16 = unknownIcon16;
    private int m_type = 0;
    private boolean m_dirty = false;
    private boolean m_bAutoStartEnabled = false;
    private boolean m_bExpandAtStartup = false;
    private boolean m_bRequestFocusAtStartup = false;

    public void displayHelp() {
        VWTaskCore.getInstance().displayHelp();
    }

    public String getHelpPath(String helpPage) {
        return VWHelp.Help_Process_TaskManager + helpPage;
    }

    public void actionPerformed(ActionEvent ae) {
    }

    public void refresh() {
        this.refreshChildren();
        if (!VWTaskCore.getInstance().isAutoMode()) {
            VWTaskPropertyPanel propertyPanel;
            VWTaskTablePanel tablePanel = this.getContentPane().getTablePanel();
            if (tablePanel != null) {
                tablePanel.refresh();
            }
            if ((propertyPanel = this.getContentPane().getPropertyPanel()) != null) {
                propertyPanel.refresh();
            }
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            ((VWTaskBaseNode)e.nextElement()).toXML(theBuffer);
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void inFocus() {
    }

    public Object lookupProcess() throws Exception {
        throw new RuntimeException("Not Supported");
    }

    public String[] getActions() {
        return null;
    }

    public boolean isActionEnabled(String actionCMD) {
        return false;
    }

    public boolean showStartIcon() {
        return false;
    }

    public boolean showStopIcon() {
        return false;
    }

    public boolean showDeleteIcon() {
        return false;
    }

    public boolean showCommitIcon() {
        return false;
    }

    public boolean showDiscardIcon() {
        return false;
    }

    public boolean showPropertyIcon() {
        return false;
    }

    public String getAutomaticallyStartedText() {
        if (this.inServiceMode()) {
            return VWResource.AutomaticallyStarted;
        }
        return VWResource.EnableAutomaticStartup;
    }

    public String getAutomaticallyStartedToolTip() {
        if (this.inServiceMode()) {
            return "";
        }
        return VWResource.EnableAutomaticStartupToolTip;
    }

    public VWTaskBaseNode(String name, String propertiesPath, String basePropertyKey, int type) throws Exception {
        super(name);
        this.m_name = name;
        this.m_type = type;
        this.setPropertyFilePath(propertiesPath);
        this.m_basePropertyKey = basePropertyKey;
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_contentPane = new VWTaskContentViewPane(this, null, null);
        }
        if (VWTaskCore.isWindowsOS() || !VWTaskCore.getInstance().isAutoMode()) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    public VWTaskBaseNode(String name, String propertiesPath) throws Exception {
        this(name, propertiesPath, null, 0);
    }

    public VWTaskBaseNode(String name, int type) throws Exception {
        this(name, null, null, type);
    }

    public VWTaskBaseNode(String name) throws Exception {
        this(name, 0);
    }

    public VWTaskBaseNode(int type) throws Exception {
        this("", type);
    }

    public VWTaskCore getTaskCore() {
        return VWTaskCore.getInstance();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setBasePropertyKey(String key) {
        this.m_basePropertyKey = key;
    }

    public String getBasePropertyKey() {
        return this.m_basePropertyKey;
    }

    private boolean getExpandAtStartup() {
        return this.m_bExpandAtStartup;
    }

    public void setExpandAtStartup(boolean expand) {
        this.m_bExpandAtStartup = expand;
    }

    private boolean getRequestFocusAtStartup() {
        return this.m_bRequestFocusAtStartup;
    }

    public void setRequestFocusAtStartup(boolean requestFocus) {
        this.m_bRequestFocusAtStartup = requestFocus;
    }

    public Icon getIcon32() {
        return this.m_icon32;
    }

    public void setIcon32(ImageIcon icon) {
        this.m_icon32 = icon;
    }

    public Icon getIcon16() {
        return this.m_icon16;
    }

    public void setIcon16(ImageIcon icon) {
        this.m_icon16 = icon;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public VWTaskContentViewPane getContentPane() {
        if (VWTaskCore.getInstance().isAutoMode()) {
            throw new IllegalStateException("Cannot call VWTaskBaseNode::getContentPane() in automode.");
        }
        return this.m_contentPane;
    }

    public void nodeChanged() {
        if (!VWTaskCore.getInstance().isAutoMode()) {
            final VWTaskBaseNode node = this;
            Runnable operation = new Runnable(){

                public void run() {
                    VWTaskCore.getInstance().getTreeModel().nodeChanged(node);
                }
            };
            VWTaskUtil.performUIOperation(operation);
        }
    }

    public void reload() {
        if (!VWTaskCore.getInstance().isAutoMode()) {
            final VWTaskBaseNode node = this;
            Runnable operation = new Runnable(){

                public void run() {
                    VWTaskBaseNode.this.getTaskCore().getTreeModel().reload(node);
                }
            };
            VWTaskUtil.performUIOperation(operation);
        }
    }

    protected void setDirty() {
        this.m_dirty = true;
    }

    protected void clearDirty() {
        this.m_dirty = false;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public void displayError(Exception ex) {
        VWTaskCore.getInstance().displayError((Throwable)ex, this);
    }

    public void displayError(Exception ex, boolean displayInMsgPanel) {
        VWTaskCore.getInstance().displayError(ex, displayInMsgPanel, this);
    }

    public void displayError(String message) {
        VWTaskCore.getInstance().displayError(message, this);
    }

    public void displayError(String message, boolean displayInMsgPanel) {
        VWTaskCore.getInstance().displayError(message, displayInMsgPanel, this);
    }

    public void displayWarning(String message) {
        VWTaskCore.getInstance().displayWarning(message, this);
    }

    public void displayWarning(String message, boolean displayInMsgPanel) {
        VWTaskCore.getInstance().displayWarning(message, displayInMsgPanel, this);
    }

    public void displayWarning(Throwable t) {
        VWTaskCore.getInstance().displayWarning(t, this);
    }

    public void displayWarning(Throwable t, boolean displayInMsgPanel) {
        VWTaskCore.getInstance().displayWarning(t, displayInMsgPanel, this);
    }

    public void displayInformation(String message) {
        VWTaskCore.getInstance().displayInformation(message);
    }

    public boolean displayConfirmation(String message) {
        return VWTaskCore.getInstance().displayConfirmation(message);
    }

    public VWTaskBaseNode getRootNode() {
        VWTaskBaseNode previous;
        TreeNode ancestor = this;
        do {
            previous = ancestor;
        } while ((ancestor = ancestor.getParent()) != null);
        return previous;
    }

    public VWTaskBaseNode findAncestorNode(int type) {
        VWTaskBaseNode bNode = this;
        while (bNode.getType() != type && (bNode = (VWTaskBaseNode)bNode.getParent()) != null) {
        }
        return bNode;
    }

    public VWTaskBaseNode[] getChildNodes() {
        if (this.getChildCount() != 0) {
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                list.add(e.nextElement());
            }
            return list.toArray(new VWTaskBaseNode[list.size()]);
        }
        return null;
    }

    public VWTaskBaseNode findChildNode(int type) {
        return this.findChildNode(type, null, false);
    }

    public VWTaskBaseNode findChildNode(String name) {
        return this.findChildNode(-1, name, false);
    }

    public VWTaskBaseNode findChildNode(int type, String name) {
        return this.findChildNode(type, name, false);
    }

    public VWTaskBaseNode findChildNode(int type, String name, boolean recursive) {
        VWTaskBaseNode[] nodes = this.findChildNodesImpl(type, name, recursive, true);
        if (nodes != null && nodes.length > 0) {
            return nodes[0];
        }
        return null;
    }

    public VWTaskBaseNode[] findChildNodes(int type) {
        return this.findChildNodesImpl(type, null, false, false);
    }

    public VWTaskBaseNode[] findChildNodes(String name) {
        return this.findChildNodesImpl(-1, name, false, false);
    }

    public VWTaskBaseNode[] findChildNodes(int type, String name, boolean bRecursive) {
        return this.findChildNodesImpl(type, name, bRecursive, false);
    }

    private VWTaskBaseNode[] findChildNodesImpl(int type, String name, boolean bRecursive, boolean returnFirst) {
        ArrayList<VWTaskBaseNode> nodes = null;
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            VWTaskBaseNode[] childNodes;
            VWTaskBaseNode bNode = (VWTaskBaseNode)e.nextElement();
            if ((bNode.getType() == type || type == -1) && (name != null && bNode.getName().equals(name) || name == null)) {
                if (nodes == null) {
                    nodes = new ArrayList<VWTaskBaseNode>();
                }
                nodes.add(bNode);
                if (returnFirst) break;
            }
            if (!bRecursive || (childNodes = bNode.findChildNodesImpl(type, name, bRecursive, returnFirst)) == null) continue;
            if (nodes == null) {
                nodes = new ArrayList();
            }
            for (int i = 0; i < childNodes.length; ++i) {
                nodes.add(childNodes[i]);
            }
            if (!returnFirst) continue;
            break;
        }
        if (nodes != null) {
            return nodes.toArray(new VWTaskBaseNode[nodes.size()]);
        }
        return null;
    }

    public void delete() {
        final VWTaskBaseNode node = this;
        Runnable operation = new Runnable(){

            public void run() {
                VWTaskBaseNode.this.getTaskCore().getTreeModel().removeNodeFromParent(node);
            }
        };
        VWTaskUtil.performUIOperation(operation);
    }

    public void removeAllChildren() {
        final VWTaskBaseNode node = this;
        Runnable operation = new Runnable(){

            public void run() {
                boolean descendantSelected = node.isNodeDescendant(VWTaskCore.getInstance().getSelectedNode());
                node.removeAllChildrenSuperImpl();
                VWTaskBaseNode.this.getTaskCore().getTreeModel().reload(node);
                VWTaskTablePanel tablePanel = node.getContentPane().getTablePanel();
                if (tablePanel != null) {
                    tablePanel.refresh();
                }
                if (descendantSelected) {
                    VWTaskCore.getInstance().setFocus(node);
                }
            }
        };
        VWTaskUtil.performUIOperation(operation);
    }

    private void removeAllChildrenSuperImpl() {
        super.removeAllChildren();
    }

    public void add(VWTaskBaseNode newChild) {
        this.add(newChild, 0);
    }

    public void add(VWTaskBaseNode newChild, int sortType) {
        block9: {
            try {
                int childCount = this.getChildCount();
                String newName = newChild.getName();
                if (childCount == 0) {
                    this.insertTaskNode(newChild, 0);
                    break block9;
                }
                boolean bDone = false;
                String childName = null;
                if (sortType == 1) {
                    for (int i = 0; i < childCount; ++i) {
                        childName = ((VWTaskBaseNode)this.getChildAt(i)).getName();
                        if (VWStringUtils.compare(newName, childName) > 0) continue;
                        this.insertTaskNode(newChild, i);
                        bDone = true;
                        break;
                    }
                } else if (sortType == 2) {
                    for (int i = 0; i < childCount; ++i) {
                        childName = ((VWTaskBaseNode)this.getChildAt(i)).getName();
                        if (VWStringUtils.compare(childName, newName) < 0) continue;
                        this.insertTaskNode(newChild, i);
                        bDone = true;
                        break;
                    }
                }
                if (!bDone) {
                    this.insertTaskNode(newChild, childCount);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public String getJREBinPath() {
        VWTaskBaseNode parent = (VWTaskBaseNode)this.getParent();
        String jreBin = null;
        if (this.m_basePropertyKey != null) {
            jreBin = this.getProperty(this.m_basePropertyKey + ".JRE", null);
        }
        if (jreBin == null && parent != null) {
            jreBin = parent.getJREBinPath();
        }
        return jreBin;
    }

    public ArrayList getVMFlags() {
        VWTaskBaseNode parent = (VWTaskBaseNode)this.getParent();
        ArrayList list = new ArrayList();
        if (this.m_basePropertyKey != null) {
            String vmFlags = this.getProperty(this.m_basePropertyKey + ".VMFlags", null);
            if (vmFlags != null) {
                StringTokenizer tokens = new StringTokenizer(vmFlags);
                while (tokens.hasMoreTokens()) {
                    list.add(tokens.nextToken());
                }
            }
            if (list.size() == 0 && parent != null) {
                list = parent.getVMFlags();
            }
        }
        return list;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.m_properties != null) {
            return this.m_properties.getProperty(key, defaultValue);
        }
        if (this.getParent() != null) {
            return ((VWTaskBaseNode)this.getParent()).getProperty(key);
        }
        return null;
    }

    public boolean getBooleanProperty(String key) {
        String value = this.getProperty(key);
        return value != null && value.equalsIgnoreCase("true");
    }

    public String getServiceName() {
        return this.getProperty("TaskManager.ServiceName", null);
    }

    public String getServiceDisplayName() {
        return this.getProperty("TaskManager.ServiceDisplayName", null);
    }

    public String getPropertyFilePath() {
        if (this.m_propertiesPath != null) {
            return this.m_propertiesPath;
        }
        if (this.getParent() != null) {
            return ((VWTaskBaseNode)this.getParent()).getPropertyFilePath();
        }
        return null;
    }

    protected void setPropertyFilePath(String path) {
        this.m_propertiesPath = path;
        this.m_properties = VWTaskApplicationSettings.getInstance().getProperties(path);
    }

    public boolean inServiceMode() {
        return this.getBooleanProperty("TaskManager.ServiceMode");
    }

    public VWTaskXMLHandler getXMLHandler() {
        if (this.m_propertiesPath != null) {
            return VWTaskCore.getInstance().getXMLHandler(this.m_propertiesPath);
        }
        if (this.getParent() != null) {
            return ((VWTaskBaseNode)this.getParent()).getXMLHandler();
        }
        return VWTaskCore.getInstance().getXMLHandler(null);
    }

    public void refreshChildren() {
        VWTaskBaseNode[] nodes = this.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i].refresh();
            }
        }
    }

    public boolean getAutoStartEnabled() {
        return this.m_bAutoStartEnabled;
    }

    public String getAutoStartAttributeString() {
        return "AutomaticallyStarted=\"" + new Boolean(this.getAutoStartEnabled()).toString() + "\"";
    }

    public void setAutoStartEnabled(boolean enabled) {
        this.m_bAutoStartEnabled = enabled;
    }

    public void setAutoStartEnabled(Element ele) {
        if (ele.getAttributeNode("AutomaticallyStarted") != null) {
            this.setAutoStartEnabled(new Boolean(ele.getAttribute("AutomaticallyStarted")));
        } else if (!(VWTaskCore.getInstance().isAutoMode() && this.inServiceMode() || ele.getAttributeNode("AutoStartupEnabled") == null)) {
            this.setAutoStartEnabled(new Boolean(ele.getAttribute("AutoStartupEnabled")));
        }
    }

    public void setConsoleHandler(IVWConsoleHandler consoleHandler) throws Exception {
        if (VWTaskCore.getInstance().isAutoMode()) {
            return;
        }
        if (this.m_consoleHandler == null || consoleHandler == null || !this.m_consoleHandler.equals(consoleHandler)) {
            if (this.m_consoleHandler != null) {
                try {
                    VWDebug.logInfo("Unregistering for console messages. Source: " + this.getName());
                    this.m_consoleHandler.removeConsole(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_consoleHandler = consoleHandler;
            if (this.m_consoleHandler != null) {
                VWDebug.logInfo("Registering for console messages. Source: " + this.getName());
                this.m_consoleHandler.addConsole((IVWConsole)this, Level.INFO);
            }
        }
    }

    protected void expandChildNodes() {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            try {
                VWTaskBaseNode node = (VWTaskBaseNode)e.nextElement();
                if (node.getExpandAtStartup()) {
                    VWTaskCore.getInstance().expandNode(node, false);
                }
                node.expandChildNodes();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    protected boolean setFocusToRequestingChildNode() {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            try {
                VWTaskBaseNode node = (VWTaskBaseNode)e.nextElement();
                if (node.getRequestFocusAtStartup()) {
                    VWTaskCore.getInstance().setFocus(node);
                    return true;
                }
                if (!node.setFocusToRequestingChildNode()) continue;
                return true;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return false;
    }

    public void consoleLevelChanged(VWConsoleEvent evt) {
        try {
            if (this.m_consoleHandler != null) {
                this.m_consoleHandler.setConsoleLevel((IVWConsole)this, evt.getConsoleLevel());
            }
        }
        catch (Exception ex) {
            VWDebug.logError("Error while notifying console handler of new console message level.");
            VWDebug.logException(ex);
        }
    }

    public void consoleVisibilityChanged(VWConsoleEvent evt) {
    }

    public void writeException(Exception e, String summary) {
        StringWriter details = new StringWriter();
        e.printStackTrace(new PrintWriter(details));
        this.writeMessage(Level.SEVERE, (summary != null ? summary + "\n\n" : "") + details.toString());
    }

    public void writeMessage(Level logLevel, String message) {
        VWDebug.logInfo(message);
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.getTaskCore().getConsoleMsgPanel().writeMessage(logLevel, message, this.getName(), this.m_icon16);
        }
    }

    public String getConsoleName() throws RemoteException, VWException {
        return this.getName();
    }

    public Vector getProperties() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public boolean getLoggingState() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void setLoggingState(boolean logState) throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public boolean getTracingState() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void setTracingState(boolean state) throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public Object lookupTaskProcess() throws Exception {
        return this.lookupProcess();
    }

    private void insertTaskNode(final VWTaskBaseNode node, final int index) {
        final VWTaskBaseNode thisNode = this;
        Runnable operation = new Runnable(){

            public void run() {
                VWTaskBaseNode selectedNode = VWTaskCore.getInstance().getSelectedNode();
                thisNode.insert(node, index);
                VWTaskRootNode root = VWTaskCore.getInstance().getRootNode();
                if (root != null && root.equals(thisNode.getRoot())) {
                    VWTaskCore.getInstance().getTreeModel().reload(thisNode);
                }
                VWTaskCore.getInstance().setFocus(selectedNode);
            }
        };
        VWTaskUtil.performUIOperation(operation);
    }

    public static String _get_FILE_DATE() {
        return "$Date:   13 Jun 2008 08:50:32  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.51  $";
    }
}

